﻿using Microsoft.AspNetCore.Builder;
using System;
using System.Collections.Generic;
using System.Data;

namespace SE290A_BackOfficeSim_CoreApi
{
    public class Program
    {
        public static DataTable LabelStatusTable = null;
        public static DataTable EventLogTable = null;
        public static Dictionary<string, EslImageInfo> LabelStatus = new Dictionary<string, EslImageInfo>();

        public static string ApiKey = "1884EEAF-50C7-4A54-B678-710AE87DEA21";  // dummy default API key

        static void Main(string[] args)
        {
            if (args != null && args.Length > 0)
            {
                foreach (string arg in args)
                {
                    string argument = arg.Substring(arg.IndexOf('=') + 1).Trim(new char[] { ' ', '"', '\'' });

                    try
                    {
                        if (arg.ToLower().StartsWith("--dbase="))
                            DatabaseHelper.SqlDatabase = argument;
                        else if (arg.ToLower().StartsWith("--server="))
                            DatabaseHelper.SqlServer = argument;
                        else if (arg.ToLower().StartsWith("--user="))
                            DatabaseHelper.SqlUserId = argument;
                        else if (arg.ToLower().StartsWith("--pass="))
                            DatabaseHelper.SqlPassword = argument;
                        else if (arg.ToLower().StartsWith("--apikey="))
                            ApiKey = argument;
                    }
                    catch { }
                }
            }

            Console.ForegroundColor = ConsoleColor.White;
            Console.WriteLine("SE-290A BackOffice Simulation Version: " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString() + " (" + DatabaseHelper.SqlDatabase + ")");
            Console.WriteLine("Press CTRL-C to terminate");

            ///NOTE: This part comes from the try-catch of the original Program.cs, after the WebService was started
            LabelStatusTable = DatabaseHelper.ReadLabelStatusTable();
            EventLogTable = DatabaseHelper.ReadEventLogTable();

            DatabaseWatcher.Start();

            try
            {
                foreach (DataRow Row in LabelStatusTable.Rows)
                {
                    string Mac = Row["MAC"].ToString();

                    EslImageInfo EslInfo = new EslImageInfo(Mac);

                    DatabaseHelper.ParseLabelStatus(ref EslInfo, Row);

                    if (!LabelStatus.ContainsKey(Mac))
                    {
                        LabelStatus.Add(Mac, EslInfo);
                    }
                    else
                    {
                        LabelStatus[Mac] = EslInfo;
                    }
                }
            }
            catch (Exception ex)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("Error parsing Label status: " + ex.Message);
            }
            ///End of try-catch code
            ///
            var builder = WebApplication.CreateBuilder(args);
            var startup = new Startup(builder.Configuration);
            startup.ConfigureServices(builder.Services);
            var app = builder.Build();
            startup.Configure(app, app.Environment);
            app.Run();

            DatabaseWatcher.Stop();
        }
    }
}
